unit Frmtest;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ASClient, ExtCtrls;

type
  TForm1 = class(TForm)
    ASClient1: TASClient;
    Button1: TButton;
    mCommand: TMemo;
    mMessages: TMemo;
    Label3: TLabel;
    Label4: TLabel;
    Panel1: TPanel;
    Label1: TLabel;
    lblDefaultSystem: TLabel;
    Label2: TLabel;
    lblStatus: TLabel;
    Exit: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
    lblDefaultSystem.Caption := ASClient1.GetDefaultSystem;
    lblStatus.Caption := IntToStr(ASClient1.IsRouterLoaded);

    If lblStatus.Caption = '1' Then
       lblStatus.Caption := lblStatus.Caption + ' = Router Loaded!'
    Else
       lblStatus.Caption := lblStatus.Caption + ' = Router Not Found!';

    lblStatus.Refresh;
    lblDefaultSystem.Refresh;
    Application.ProcessMessages;

end;

procedure TForm1.Button1Click(Sender: TObject);
begin

    { Give the command to the VCL }
    ASClient1.Command.Clear;
    ASClient1.Command.Assign(mCommand.Lines);

    { Send the Command to the AS/400 }
    try
       Screen.Cursor := crHourglass;
       { Clear the Message Que }
       ASClient1.Messages.Clear;
       { Send the Command!!! }
       ASClient1.SendCommand(Form1.Handle);
    finally
       Screen.Cursor := crDefault;
    end;

    { Get the Messages from the AS/400 }
    { and clear out the command... }
    mMessages.Lines.Clear;
    mMessages.Lines.Assign(ASClient1.Messages);
    mCommand.Lines.Clear;
    mCommand.SetFocus;

    Application.ProcessMessages;

end;

procedure TForm1.ExitClick(Sender: TObject);
begin
     { Haven't had any problems not calling StopConversation, but
       it's always safe to do so... }
     ASClient1.StopConversation(Form1.Handle);
     Close;
end;

end.
